clear all;
close all;

%% Load data and shift so that bandstructure can be plotted as lines

load('strip_freq_g0.mat');
bandgap = 330.4e6;
[energy, g0] = lines_shift(Eval_mech.bands, Eval_mech.g0, bandgap);

%% Plot strip band structure

figure(2)
subplot2 = subplot(1,1,1);
set(subplot2,'FontSize',16,'XTick',[-pi/geom.mech.amech -2*pi/(3*geom.mech.amech) 0 2*pi/(3*geom.mech.amech) pi/geom.mech.amech],...
    'XTickLabel',{'-\pi', '-2\pi/3', '0', '2\pi/3', '\pi'});

xlim(subplot2,[-pi/geom.mech.amech pi/geom.mech.amech]); % Band structure showing the 1st cone
ylim(subplot2,[311e6 354e6]); % Band structure showing the 1st cone

yticks(linspace(310e6, 350e6, 5))

hold on;
box on;

% for i=1:size(Eval_mech.bands,1)
%     for j=1:size(Eval_mech.bands,2)
%         plot(Eval_mech.kx(j), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 10);
%         plot(-Eval_mech.kx(j), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 10);
%     end
% end

for i=1:size(energy,1)
    plot(Eval_mech.kx, real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
    plot(-Eval_mech.kx, real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
end

% plot(Eval_mech.kx, real(energy(20,:)), 'Color', 'red', 'LineWidth', 3);

% % Physical edge state modes
% colour_edge_mode = [146/256, 146/256, 146/256, 1];
% 
% plot(Eval_mech.kx, real(energy(19,:)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-Eval_mech.kx, real(energy(19,:)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(Eval_mech.kx(25:30), real(energy(21,25:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-Eval_mech.kx(25:30), real(energy(21,(25:30))), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% % plot(Eval_mech.kx, real(energy(21,:)), 'Color', colour_edge_mode, 'LineWidth', 2);
% % plot(-Eval_mech.kx, real(energy(21,:)), 'Color', colour_edge_mode, 'LineWidth', 2);